unit uSystemObsugiKartKredytowych;

interface

uses
  uWeryfikatorKartKredytowych, SysUtils;

type
  TSystemObsugiKartKredytowych = class
  private
    FWeryfikatorKartKredytowych: IWeryfikatorKartKredytowych;
  public
    constructor Create(aWeryfikatorKartKredytowych: IWeryfikatorKartKredytowych);
    function KartaWana(aNrKarty: string): Boolean;
    function PatnoKart(aNrKarty: string; aKwota: Double): Double;
  end;

  ENiewanaKarta= class(Exception);

implementation

function TSystemObsugiKartKredytowych.KartaWana(aNrKarty: string): Boolean;
begin
  inherited;
  Result := FWeryfikatorKartKredytowych.CzyKartaJestWana(aNrKarty);
end;

function TSystemObsugiKartKredytowych.PatnoKart(aNrKarty: string; aKwota: Double): Double;
begin
  if KartaWana(aNrKarty) then
  begin
    // Obcienie karty
    Result := aKwota;
  end else
  begin
    Result := 0.0;
  end;
end;

constructor TSystemObsugiKartKredytowych.Create(aWeryfikatorKartKredytowych: IWeryfikatorKartKredytowych);
begin
  inherited Create;
  FWeryfikatorKartKredytowych := aWeryfikatorKartKredytowych;
end;

end.

